#include <iostream>
#include <algorithm>

#define MAX_N 200000

unsigned long long a[MAX_N];
unsigned long long K[MAX_N];

unsigned long long coef(unsigned long long k, unsigned long long n)
{	
	if (k == 0 || k == n)
		return 1;
			
	long long p = 1;
	for (int i = k + 1; i <= n; ++i)
		p *= i;
	for (int i = 2; i <= n - k; ++i)
		p /= i;
		
	return p;
}



int main()
{	
	long long unsigned N, T, C;
	scanf("%llu%llu%llu", &N, &T, &C);
	
	unsigned long long Cpow = 1;
	for (int i = 0; i < T; ++i)
		Cpow *= C;
	
	for (int i = 0; i < N; ++i)	
		scanf("%llu", &a[i]);

	for (int i = 0; i < N; ++i)
		scanf("%llu", &K[i]);	
		
	K[0] = 1;		
		
	unsigned long long sum = 0;
	unsigned long long fact = 1;
	unsigned long long Kfact = 1;
	for (int i = 0; i < std::min(T, N); ++i)
	{		
		unsigned long long c = coef(i, T);		
		//printf("c=%llu Cpow=%llu a[i]=%llu fact=%llu Kfact=%lli\n", c, Cpow, a[i], fact, Kfact);
		sum += c * Cpow * a[i] * fact * Kfact;
		fact *= (i + 1);
		Kfact *= K[i];
		Cpow /= C;
	}
			
	printf("%llu", sum % 1000000007);	
	
	return 0;
}